"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readStorybookConfig = void 0;
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const utils_1 = require("../utils");
const defaultConfigDir = path_1.default.join(process.cwd(), '.storybook');
function validateMainJs(mainJs) {
    if (typeof mainJs !== 'object') {
        throw utils_1.createError('main.js must export an object');
    }
    if (mainJs.stories == null) {
        throw utils_1.createError('Missing stories option in main.js');
    }
    if (!(Array.isArray(mainJs.stories) || typeof mainJs.stories === 'function')) {
        throw utils_1.createError('Stories option main.js must be an array or function');
    }
    if (mainJs.addons != null) {
        if (!Array.isArray(mainJs.addons)) {
            throw utils_1.createError('Addons in main.js must be an array');
        }
        if (mainJs.addons.some(addon => addon.startsWith('@storybook'))) {
            throw utils_1.createError('Official storybook addons are not es modules, and cannot be loaded from this storybook implementation.');
        }
    }
    return mainJs;
}
function readStorybookConfig(pluginConfig) {
    const configDir = pluginConfig.configDir
        ? path_1.default.resolve(pluginConfig.configDir)
        : defaultConfigDir;
    const mainJsPath = path_1.default.join(configDir, 'main.js');
    const managerJsPath = path_1.default.join(configDir, 'manager.js');
    const previewJsPath = path_1.default.join(configDir, 'preview.js');
    const managerHeadPath = path_1.default.join(configDir, 'manager-head.html');
    const previewHeadPath = path_1.default.join(configDir, 'preview-head.html');
    const previewBodyPath = path_1.default.join(configDir, 'preview-body.html');
    let managerHead = undefined;
    let previewHead = undefined;
    let previewBody = undefined;
    if (!fs_1.default.existsSync(mainJsPath)) {
        throw utils_1.createError(`Could not find any storybook configuration at ${mainJsPath}. You can change the storybook config directory using the configDir option.`);
    }
    if (fs_1.default.existsSync(managerHeadPath)) {
        managerHead = fs_1.default.readFileSync(managerHeadPath, 'utf-8');
    }
    if (fs_1.default.existsSync(previewHeadPath)) {
        previewHead = fs_1.default.readFileSync(previewHeadPath, 'utf-8');
    }
    if (fs_1.default.existsSync(previewBodyPath)) {
        previewBody = fs_1.default.readFileSync(previewBodyPath, 'utf-8');
    }
    const mainJs = validateMainJs(require(mainJsPath));
    return {
        mainJs,
        mainJsPath,
        managerJsPath,
        previewJsPath,
        managerHead,
        previewHead,
        previewBody,
    };
}
exports.readStorybookConfig = readStorybookConfig;
//# sourceMappingURL=readStorybookConfig.js.map