"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRollupConfig = void 0;
const plugin_node_resolve_1 = __importDefault(require("@rollup/plugin-node-resolve"));
const plugin_babel_1 = __importDefault(require("@rollup/plugin-babel"));
const rollup_plugin_html_1 = __importDefault(require("@web/rollup-plugin-html"));
const rollup_plugin_polyfills_loader_1 = __importDefault(require("@web/rollup-plugin-polyfills-loader"));
const core_1 = require("@babel/core");
const rollup_plugin_terser_1 = require("rollup-plugin-terser");
const mdxPlugin_1 = require("./mdxPlugin");
const mdjsPlugin_1 = require("./mdjsPlugin");
const injectExportsOrderPlugin_1 = require("./injectExportsOrderPlugin");
const prebuiltDir = require
    .resolve('@web/storybook-prebuilt/package.json')
    .replace('/package.json', '');
const ignoredWarnings = ['EVAL', 'THIS_IS_UNDEFINED'];
function onwarn(warning, warn) {
    if (ignoredWarnings.includes(warning.code)) {
        return;
    }
    warn(warning);
}
function createRollupConfig(params) {
    const { outputDir, indexFilename, indexHtmlString, storyFilePaths } = params;
    const options = {
        preserveEntrySignatures: false,
        onwarn,
        output: {
            entryFileNames: '[hash].js',
            chunkFileNames: '[hash].js',
            assetFileNames: '[hash][extname]',
            format: 'system',
            dir: outputDir,
        },
        plugins: [
            plugin_node_resolve_1.default({
                moduleDirectories: ['node_modules', 'web_modules'],
            }),
            plugin_babel_1.default({
                babelHelpers: 'bundled',
                babelrc: false,
                configFile: false,
                extensions: [...core_1.DEFAULT_EXTENSIONS, 'md', 'mdx'],
                exclude: `${prebuiltDir}/**`,
                presets: [
                    [
                        require.resolve('@babel/preset-env'),
                        {
                            targets: [
                                'last 3 Chrome major versions',
                                'last 3 ChromeAndroid major versions',
                                'last 3 Firefox major versions',
                                'last 3 Edge major versions',
                                'last 3 Safari major versions',
                                'last 3 iOS major versions',
                                'ie 11',
                            ],
                            useBuiltIns: false,
                            shippedProposals: true,
                            modules: false,
                            bugfixes: true,
                        },
                    ],
                ],
                plugins: [
                    [require.resolve('babel-plugin-bundled-import-meta'), { importStyle: 'baseURI' }],
                    [
                        require.resolve('babel-plugin-template-html-minifier'),
                        {
                            modules: {
                                // this is web component specific, but has no effect on other project styles
                                'lit-html': ['html'],
                                'lit-element': ['html', { name: 'css', encapsulation: 'style' }],
                                '@web/storybook-prebuilt/web-components': [
                                    'html',
                                    { name: 'css', encapsulation: 'style' },
                                ],
                                '@web/storybook-prebuilt/web-components.js': [
                                    'html',
                                    { name: 'css', encapsulation: 'style' },
                                ],
                                '@open-wc/testing': ['html', { name: 'css', encapsulation: 'style' }],
                                '@open-wc/testing-helpers': ['html', { name: 'css', encapsulation: 'style' }],
                            },
                            logOnError: true,
                            failOnError: false,
                            strictCSS: true,
                            htmlMinifier: {
                                collapseWhitespace: true,
                                conservativeCollapse: true,
                                removeComments: true,
                                caseSensitive: true,
                                minifyCSS: true,
                            },
                        },
                    ],
                ],
            }),
            rollup_plugin_html_1.default({ input: { name: indexFilename, html: indexHtmlString } }),
            rollup_plugin_polyfills_loader_1.default({
                polyfills: {
                    coreJs: true,
                    fetch: true,
                    abortController: true,
                    regeneratorRuntime: 'always',
                    webcomponents: true,
                    intersectionObserver: true,
                    resizeObserver: true,
                },
            }),
            rollup_plugin_terser_1.terser({ format: { comments: false } }),
        ],
    };
    if (storyFilePaths && storyFilePaths.length > 0) {
        // plugins we need to inject only in the preview
        options.plugins.unshift(injectExportsOrderPlugin_1.injectExportsOrderPlugin(storyFilePaths));
        options.plugins.unshift(mdxPlugin_1.mdxPlugin());
        options.plugins.unshift(mdjsPlugin_1.mdjsPlugin(params.type));
    }
    return options;
}
exports.createRollupConfig = createRollupConfig;
//# sourceMappingURL=createRollupConfig.js.map