"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.build = void 0;
const readStorybookConfig_1 = require("../shared/config/readStorybookConfig");
const validatePluginConfig_1 = require("../shared/config/validatePluginConfig");
const createRollupConfig_1 = require("./rollup/createRollupConfig");
const buildAndWrite_1 = require("./rollup/buildAndWrite");
const createManagerHtml_1 = require("../shared/html/createManagerHtml");
const createPreviewHtml_1 = require("../shared/html/createPreviewHtml");
const findStories_1 = require("../shared/stories/findStories");
async function buildPreview(params) {
    var _a;
    const { type, storybookConfig, pluginConfig, outputDir, rootDir } = params;
    const { storyImports, storyFilePaths } = await findStories_1.findStories(rootDir, storybookConfig.mainJsPath, storybookConfig.mainJs.stories);
    const previewHtml = createPreviewHtml_1.createPreviewHtml(pluginConfig, storybookConfig, rootDir, storyImports);
    let config = createRollupConfig_1.createRollupConfig({
        type,
        outputDir,
        indexFilename: 'iframe.html',
        indexHtmlString: previewHtml,
        storyFilePaths,
    });
    if (storybookConfig.mainJs.rollupConfig) {
        config = (_a = (await storybookConfig.mainJs.rollupConfig(config))) !== null && _a !== void 0 ? _a : config;
    }
    await buildAndWrite_1.buildAndWrite(config);
}
async function buildManager(params) {
    const managerHtml = createManagerHtml_1.createManagerHtml(params.storybookConfig, params.rootDir);
    const config = createRollupConfig_1.createRollupConfig({
        type: params.type,
        outputDir: params.outputDir,
        indexFilename: 'index.html',
        indexHtmlString: managerHtml,
    });
    await buildAndWrite_1.buildAndWrite(config);
}
async function build(params) {
    const { type, outputDir } = params;
    const rootDir = process.cwd();
    validatePluginConfig_1.validatePluginConfig(params);
    const storybookConfig = readStorybookConfig_1.readStorybookConfig(params);
    await buildManager({ type, outputDir, storybookConfig, rootDir });
    await buildPreview({ type, storybookConfig, pluginConfig: params, outputDir, rootDir });
}
exports.build = build;
//# sourceMappingURL=build.js.map