"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRollupPluginContextAdapter = void 0;
const path_1 = __importDefault(require("path"));
function createRollupPluginContextAdapter(pluginContext, wdsPlugin, config, fileWatcher, context, pluginMetaPerModule) {
    return Object.assign(Object.assign({}, pluginContext), { getModuleInfo(id) {
            var _a;
            return {
                id,
                code: context.body,
                ast: null,
                dynamicallyImportedIds: [],
                dynamicallyImportedIdResolutions: [],
                dynamicImporters: [],
                hasDefaultExport: false,
                implicitlyLoadedBefore: [],
                implicitlyLoadedAfterOneOf: [],
                importedIds: [],
                importedIdResolutions: [],
                importers: [],
                isEntry: false,
                isExternal: false,
                isIncluded: false,
                hasModuleSideEffects: false,
                moduleSideEffects: false,
                syntheticNamedExports: false,
                meta: (_a = pluginMetaPerModule.get(id)) !== null && _a !== void 0 ? _a : {},
            };
        },
        addWatchFile(id) {
            const filePath = path_1.default.join(process.cwd(), id);
            fileWatcher.add(filePath);
        }, emitAsset() {
            throw new Error('Emitting files is not yet supported');
        },
        emitFile() {
            throw new Error('Emitting files is not yet supported');
        },
        getAssetFileName() {
            throw new Error('Emitting files is not yet supported');
        },
        getFileName() {
            throw new Error('Emitting files is not yet supported');
        },
        setAssetSource() {
            throw new Error('Emitting files is not yet supported');
        }, async resolve(source, importer, options) {
            var _a;
            if (!context)
                throw new Error('Context is required.');
            for (const pl of (_a = config.plugins) !== null && _a !== void 0 ? _a : []) {
                if (pl.resolveImport &&
                    (!options.skipSelf || pl.resolveImport !== wdsPlugin.resolveImport)) {
                    const result = await pl.resolveImport({ source, context });
                    let resolvedId;
                    if (typeof result === 'string') {
                        resolvedId = result;
                    }
                    else if (typeof result === 'object') {
                        resolvedId = result === null || result === void 0 ? void 0 : result.id;
                    }
                    if (resolvedId) {
                        const importerDir = path_1.default.dirname(importer);
                        return {
                            id: path_1.default.isAbsolute(resolvedId) ? resolvedId : path_1.default.join(importerDir, resolvedId),
                        };
                    }
                }
            }
        },
        async resolveId(source, importer, options) {
            const resolveResult = await this.resolve(source, importer, options);
            if (typeof resolveResult === 'string') {
                return resolveResult;
            }
            if (typeof resolveResult === 'object') {
                return resolveResult === null || resolveResult === void 0 ? void 0 : resolveResult.id;
            }
            return resolveResult;
        } });
}
exports.createRollupPluginContextAdapter = createRollupPluginContextAdapter;
//# sourceMappingURL=createRollupPluginContextAdapter.js.map