/// <reference types="node" />
import { Server } from 'net';
import WebSocket from 'ws';
import { EventEmitter } from './EventEmitter';
export declare const NAME_WEB_SOCKET_IMPORT = "/__web-dev-server__web-socket.js";
export declare const NAME_WEB_SOCKET_API = "wds";
export declare type WebSocketData = {
    type: string;
} & Record<string, unknown>;
export interface Events {
    message: {
        webSocket: WebSocket;
        data: WebSocketData;
    };
}
/**
 * Manages web sockets. When the browser opens a web socket connection, the socket is stored
 * until it is disconnected. The dev server or plugins can then send messages to the browser.
 */
export declare class WebSocketsManager extends EventEmitter<Events> {
    webSocketImport: string;
    webSocketServer: WebSocket.Server;
    private openSockets;
    constructor(server: Server);
    /**
     * Imports the given path, executing the module as well as a default export if it exports a function.
     *
     * This is a built-in web socket message and will be handled automatically.
     *
     * @param importPath the path to import
     * @param args optional args to pass to the function that is called.
     */
    sendImport(importPath: string, args?: unknown[]): void;
    /**
     * Logs a message to the browser console of all connected web sockets.
     *
     * This is a built-in web socket message and will be handled automatically.
     *
     * @param text message to send
     */
    sendConsoleLog(text: string): void;
    /**
     * Sends messages to all connected web sockets.
     *
     * @param message
     */
    send(message: string): void;
}
//# sourceMappingURL=WebSocketsManager.d.ts.map