"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.expectNotIncludes = exports.expectIncludes = exports.fetchText = exports.timeout = exports.createTestServer = exports.virtualFilesPlugin = void 0;
const portfinder_1 = __importDefault(require("portfinder"));
const chai_1 = require("chai");
const nanocolors_1 = require("nanocolors");
const node_fetch_1 = __importDefault(require("node-fetch"));
const DevServer_1 = require("./server/DevServer");
const defaultConfig = {
    hostname: 'localhost',
    injectWebSocket: true,
    middleware: [],
    plugins: [],
};
const mockLogger = Object.assign(Object.assign({}, console), { debug() {
        // no debug
    },
    logSyntaxError(error) {
        console.error(error);
    } });
function virtualFilesPlugin(servedFiles) {
    return {
        name: 'test-helpers-virtual-files',
        serve(context) {
            if (context.path in servedFiles) {
                return servedFiles[context.path];
            }
        },
    };
}
exports.virtualFilesPlugin = virtualFilesPlugin;
async function createTestServer(config, _mockLogger = mockLogger) {
    if (!config.rootDir) {
        throw new Error('A rootDir must be configured.');
    }
    const port = await portfinder_1.default.getPortPromise({
        port: 9000 + Math.floor(Math.random() * 1000),
    });
    const server = new DevServer_1.DevServer(Object.assign(Object.assign(Object.assign({}, defaultConfig), config), { rootDir: config.rootDir, port }), _mockLogger);
    await server.start();
    return { server, port, host: `http://localhost:${port}` };
}
exports.createTestServer = createTestServer;
const timeout = (ms = 0) => new Promise(resolve => setTimeout(resolve, ms));
exports.timeout = timeout;
async function fetchText(url, init) {
    const response = await node_fetch_1.default(url, init);
    chai_1.expect(response.status).to.equal(200);
    return response.text();
}
exports.fetchText = fetchText;
function expectIncludes(text, expected) {
    if (!text.includes(expected)) {
        throw new Error(nanocolors_1.red(`Expected "${nanocolors_1.yellow(expected)}" in string: \n\n${nanocolors_1.green(text)}`));
    }
}
exports.expectIncludes = expectIncludes;
function expectNotIncludes(text, expected) {
    if (text.includes(expected)) {
        throw new Error(`Did not expect "${expected}" in string: \n\n${text}`);
    }
}
exports.expectNotIncludes = expectNotIncludes;
//# sourceMappingURL=test-helpers.js.map