/// <reference types="node" />
import Koa from 'koa';
import { Server } from 'net';
import chokidar from 'chokidar';
import { DevServerCoreConfig } from './DevServerCoreConfig';
import { Logger } from '../logger/Logger';
import { WebSocketsManager } from '../web-sockets/WebSocketsManager';
export declare class DevServer {
    config: DevServerCoreConfig;
    logger: Logger;
    fileWatcher: chokidar.FSWatcher;
    koaApp: Koa;
    server: Server;
    webSockets: WebSocketsManager;
    private started;
    private connections;
    constructor(config: DevServerCoreConfig, logger: Logger, fileWatcher?: chokidar.FSWatcher);
    start(): Promise<void>;
    private closeServer;
    stop(): Promise<void[] | undefined>;
}
//# sourceMappingURL=DevServer.d.ts.map