import type { AddEventResult, EventBuffer, RecordingEvent } from './types';
interface CreateEventBufferParams {
    useCompression: boolean;
}
/**
 * Create an event buffer for replays.
 */
export declare function createEventBuffer({ useCompression }: CreateEventBufferParams): EventBuffer;
/**
 * Event buffer that uses a web worker to compress events.
 * Exported only for testing.
 */
export declare class EventBufferCompressionWorker implements EventBuffer {
    /**
     * Keeps track of the list of events since the last flush that have not been compressed.
     * For example, page is reloaded and a flush attempt is made, but
     * `finish()` (and thus the flush), does not complete.
     */
    _pendingEvents: RecordingEvent[];
    private _worker;
    private _eventBufferItemLength;
    private _id;
    constructor(worker: Worker);
    /**
     * The number of raw events that are buffered. This may not be the same as
     * the number of events that have been compresed in the worker because
     * `addEvent` is async.
     */
    get pendingLength(): number;
    /**
     * Returns a list of the raw recording events that are being compressed.
     */
    get pendingEvents(): RecordingEvent[];
    /**
     * Destroy the event buffer.
     */
    destroy(): void;
    /**
     * Add an event to the event buffer.
     *
     * Returns true if event was successfuly received and processed by worker.
     */
    addEvent(event: RecordingEvent, isCheckout?: boolean): Promise<AddEventResult>;
    /**
     * Finish the event buffer and return the compressed data.
     */
    finish(): Promise<Uint8Array>;
    /**
     * Post message to worker and wait for response before resolving promise.
     */
    private _postMessage;
    /**
     * Send the event to the worker.
     */
    private _sendEventToWorker;
    /**
     * Finish the request and return the compressed data from the worker.
     */
    private _finishRequest;
    /** Get the current ID and increment it for the next call. */
    private _getAndIncrementId;
}
export {};
//# sourceMappingURL=eventBuffer.d.ts.map