import type { ReplayContainer } from '../types';
declare type XHRSendInput = null | Blob | BufferSource | FormData | URLSearchParams | string;
interface SentryWrappedXMLHttpRequest extends XMLHttpRequest {
    [key: string]: unknown;
    __sentry_xhr__?: {
        method?: string;
        url?: string;
        status_code?: number;
        body?: XHRSendInput;
        startTimestamp?: number;
    };
    __sentry_own_request__?: boolean;
}
interface XhrHandlerData {
    args: [string, string];
    xhr: SentryWrappedXMLHttpRequest;
    startTimestamp: number;
    endTimestamp?: number;
}
/**
 * Returns a listener to be added to `addInstrumentationHandler('xhr', listener)`.
 */
export declare function handleXhrSpanListener(replay: ReplayContainer): (handlerData: XhrHandlerData) => void;
export {};
//# sourceMappingURL=handleXhr.d.ts.map