import { MAX_SESSION_LIFE } from '../constants.js';
import { isExpired } from './isExpired.js';

/**
 * Checks to see if session is expired
 */
function isSessionExpired(session, idleTimeout, targetTime = +new Date()) {
  return (
    // First, check that maximum session length has not been exceeded
    isExpired(session.started, MAX_SESSION_LIFE, targetTime) ||
    // check that the idle timeout has not been exceeded (i.e. user has
    // performed an action within the last `idleTimeout` ms)
    isExpired(session.lastActivity, idleTimeout, targetTime)
  );
}

export { isSessionExpired };
//# sourceMappingURL=isSessionExpired.js.map
