import { WINDOW, REPLAY_SESSION_KEY } from '../constants.js';

/**
 * Save a session to session storage.
 */
function saveSession(session) {
  const hasSessionStorage = 'sessionStorage' in WINDOW;
  if (!hasSessionStorage) {
    return;
  }

  try {
    WINDOW.sessionStorage.setItem(REPLAY_SESSION_KEY, JSON.stringify(session));
  } catch (e) {
    // Ignore potential SecurityError exceptions
  }
}

export { saveSession };
//# sourceMappingURL=saveSession.js.map
