import { logger } from '@sentry/utils';
import { isSessionExpired } from '../util/isSessionExpired.js';
import { createSession } from './createSession.js';
import { fetchSession } from './fetchSession.js';

/**
 * Get or create a session
 */
function getSession({
  expiry,
  currentSession,
  stickySession,
  sessionSampleRate,
  errorSampleRate,
}) {
  // If session exists and is passed, use it instead of always hitting session storage
  const session = currentSession || (stickySession && fetchSession());

  if (session) {
    // If there is a session, check if it is valid (e.g. "last activity" time
    // should be within the "session idle time", and "session started" time is
    // within "max session time").
    const isExpired = isSessionExpired(session, expiry);

    if (!isExpired) {
      return { type: 'saved', session };
    } else {
      (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && logger.log('[Replay] Session has expired');
    }
    // Otherwise continue to create a new session
  }

  const newSession = createSession({
    stickySession,
    sessionSampleRate,
    errorSampleRate,
  });

  return { type: 'new', session: newSession };
}

export { getSession };
//# sourceMappingURL=getSession.js.map
