Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');

/**
 * Check whether a given request URL should be filtered out.
 */
function shouldFilterRequest(replay, url) {
  // If we enabled the `traceInternals` experiment, we want to trace everything
  if ((typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && replay.getOptions()._experiments.traceInternals) {
    return false;
  }

  return !_isSentryRequest(url);
}

/**
 * Checks wether a given URL belongs to the configured Sentry DSN.
 */
function _isSentryRequest(url) {
  const client = core.getCurrentHub().getClient();
  const dsn = client && client.getDsn();
  return dsn ? url.includes(dsn.host) : false;
}

exports.shouldFilterRequest = shouldFilterRequest;
//# sourceMappingURL=shouldFilterRequest.js.map
