Object.defineProperty(exports, '__esModule', { value: true });

require('../node_modules/rrweb/es/rrweb/packages/rrweb/src/entries/all.js');
const addEvent = require('./addEvent.js');
const types = require('../node_modules/rrweb/es/rrweb/packages/rrweb/src/types.js');

/**
 * Create a "span" for each performance entry. The parent transaction is `this.replayEvent`.
 */
function createPerformanceSpans(
  replay,
  entries,
) {
  return entries.map(({ type, start, end, name, data }) =>
    addEvent.addEvent(replay, {
      type: types.EventType.Custom,
      timestamp: start,
      data: {
        tag: 'performanceSpan',
        payload: {
          op: type,
          description: name,
          startTimestamp: start,
          endTimestamp: end,
          data,
        },
      },
    }),
  );
}

exports.createPerformanceSpans = createPerformanceSpans;
//# sourceMappingURL=createPerformanceSpans.js.map
