Object.defineProperty(exports, '__esModule', { value: true });

const constants = require('../constants.js');

/**
 * Save a session to session storage.
 */
function saveSession(session) {
  const hasSessionStorage = 'sessionStorage' in constants.WINDOW;
  if (!hasSessionStorage) {
    return;
  }

  try {
    constants.WINDOW.sessionStorage.setItem(constants.REPLAY_SESSION_KEY, JSON.stringify(session));
  } catch (e) {
    // Ignore potential SecurityError exceptions
  }
}

exports.saveSession = saveSession;
//# sourceMappingURL=saveSession.js.map
