Object.defineProperty(exports, '__esModule', { value: true });

const utils = require('@sentry/utils');
const isSessionExpired = require('../util/isSessionExpired.js');
const createSession = require('./createSession.js');
const fetchSession = require('./fetchSession.js');

/**
 * Get or create a session
 */
function getSession({
  expiry,
  currentSession,
  stickySession,
  sessionSampleRate,
  errorSampleRate,
}) {
  // If session exists and is passed, use it instead of always hitting session storage
  const session = currentSession || (stickySession && fetchSession.fetchSession());

  if (session) {
    // If there is a session, check if it is valid (e.g. "last activity" time
    // should be within the "session idle time", and "session started" time is
    // within "max session time").
    const isExpired = isSessionExpired.isSessionExpired(session, expiry);

    if (!isExpired) {
      return { type: 'saved', session };
    } else {
      (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && utils.logger.log('[Replay] Session has expired');
    }
    // Otherwise continue to create a new session
  }

  const newSession = createSession.createSession({
    stickySession,
    sessionSampleRate,
    errorSampleRate,
  });

  return { type: 'new', session: newSession };
}

exports.getSession = getSession;
//# sourceMappingURL=getSession.js.map
