Object.defineProperty(exports, '__esModule', { value: true });

const tslib_es6 = require('../../ext/tslib/tslib.es6.js');
const observer = require('./observer.js');
const utils = require('../utils.js');

var ShadowDomManager = (function () {
    function ShadowDomManager(options) {
        this.restorePatches = [];
        this.mutationCb = options.mutationCb;
        this.scrollCb = options.scrollCb;
        this.bypassOptions = options.bypassOptions;
        this.mirror = options.mirror;
        var manager = this;
        this.restorePatches.push(utils.patch(HTMLElement.prototype, 'attachShadow', function (original) {
            return function () {
                var shadowRoot = original.apply(this, arguments);
                if (this.shadowRoot)
                    manager.addShadowRoot(this.shadowRoot, this.ownerDocument);
                return shadowRoot;
            };
        }));
    }
    ShadowDomManager.prototype.addShadowRoot = function (shadowRoot, doc) {
        observer.initMutationObserver(tslib_es6.__assign(tslib_es6.__assign({}, this.bypassOptions), { doc: doc, mutationCb: this.mutationCb, mirror: this.mirror, shadowDomManager: this }), shadowRoot);
        observer.initScrollObserver(tslib_es6.__assign(tslib_es6.__assign({}, this.bypassOptions), { scrollCb: this.scrollCb, doc: shadowRoot, mirror: this.mirror }));
    };
    ShadowDomManager.prototype.observeAttachShadow = function (iframeElement) {
        if (iframeElement.contentWindow) {
            var manager_1 = this;
            this.restorePatches.push(utils.patch(iframeElement.contentWindow.HTMLElement.prototype, 'attachShadow', function (original) {
                return function () {
                    var shadowRoot = original.apply(this, arguments);
                    if (this.shadowRoot)
                        manager_1.addShadowRoot(this.shadowRoot, iframeElement.contentDocument);
                    return shadowRoot;
                };
            }));
        }
    };
    ShadowDomManager.prototype.reset = function () {
        this.restorePatches.forEach(function (restorePatch) { return restorePatch(); });
    };
    return ShadowDomManager;
}());

exports.ShadowDomManager = ShadowDomManager;
//# sourceMappingURL=shadow-dom-manager.js.map
