Object.defineProperty(exports, '__esModule', { value: true });

const createPerformanceSpans = require('../util/createPerformanceSpans.js');

function handleHistory(handlerData) {
  const { from, to } = handlerData;

  const now = new Date().getTime() / 1000;

  return {
    type: 'navigation.push',
    start: now,
    end: now,
    name: to,
    data: {
      previous: from,
    },
  };
}

/**
 * Returns a listener to be added to `addInstrumentationHandler('history', listener)`.
 */
function handleHistorySpanListener(replay) {
  return (handlerData) => {
    if (!replay.isEnabled()) {
      return;
    }

    const result = handleHistory(handlerData);

    if (result === null) {
      return;
    }

    // Need to collect visited URLs
    replay.getContext().urls.push(result.name);
    replay.triggerUserActivity();

    replay.addUpdate(() => {
      createPerformanceSpans.createPerformanceSpans(replay, [result]);
      // Returning false to flush
      return false;
    });
  };
}

exports.handleHistorySpanListener = handleHistorySpanListener;
//# sourceMappingURL=handleHistory.js.map
