Object.defineProperty(exports, '__esModule', { value: true });

const createPerformanceSpans = require('../util/createPerformanceSpans.js');
const shouldFilterRequest = require('../util/shouldFilterRequest.js');

/** only exported for tests */
function handleFetch(handlerData) {
  if (!handlerData.endTimestamp) {
    return null;
  }

  const { startTimestamp, endTimestamp, fetchData, response } = handlerData;

  return {
    type: 'resource.fetch',
    start: startTimestamp / 1000,
    end: endTimestamp / 1000,
    name: fetchData.url,
    data: {
      method: fetchData.method,
      statusCode: response.status,
    },
  };
}

/**
 * Returns a listener to be added to `addInstrumentationHandler('fetch', listener)`.
 */
function handleFetchSpanListener(replay) {
  return (handlerData) => {
    if (!replay.isEnabled()) {
      return;
    }

    const result = handleFetch(handlerData);

    if (result === null) {
      return;
    }

    if (shouldFilterRequest.shouldFilterRequest(replay, result.name)) {
      return;
    }

    replay.addUpdate(() => {
      createPerformanceSpans.createPerformanceSpans(replay, [result]);
      // Returning true will cause `addUpdate` to not flush
      // We do not want network requests to cause a flush. This will prevent
      // recurring/polling requests from keeping the replay session alive.
      return true;
    });
  };
}

exports.handleFetch = handleFetch;
exports.handleFetchSpanListener = handleFetchSpanListener;
//# sourceMappingURL=handleFetch.js.map
