import { EventProcessor, Hub, Integration } from '@sentry/types';
import { Debugger, InspectorNotification } from 'inspector';
export interface DebugSession {
    /** Configures and connects to the debug session */
    configureAndConnect(onPause: (message: InspectorNotification<Debugger.PausedEventDataType>) => void): void;
    /** Gets local variables for an objectId */
    getLocalVariables(objectId: string): Promise<Record<string, unknown>>;
}
export interface FrameVariables {
    function: string;
    vars?: Record<string, unknown>;
}
/** There are no options yet. This allows them to be added later without breaking changes */
interface Options {
}
/**
 * Adds local variables to exception frames
 */
export declare class LocalVariables implements Integration {
    private readonly _session;
    static id: string;
    readonly name: string;
    private readonly _cachedFrames;
    constructor(_options?: Options, _session?: DebugSession);
    /**
     * @inheritDoc
     */
    setupOnce(addGlobalEventProcessor: (callback: EventProcessor) => void, getCurrentHub: () => Hub): void;
    /** Setup in a way that's easier to call from tests */
    private _setup;
    /**
     * Handle the pause event
     */
    private _handlePaused;
    /**
     * Adds local variables event stack frames.
     */
    private _addLocalVariables;
    /**
     * Adds local variables to the exception stack frames.
     */
    private _addLocalVariablesToException;
}
export {};
//# sourceMappingURL=localvariables.d.ts.map