Object.defineProperty(exports, "__esModule", { value: true });
exports.makeRendererTransport = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@sentry/core");
const ipc_1 = require("./ipc");
/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    const ipc = (0, ipc_1.getIPC)();
    return (0, core_1.createTransport)(options, (request) => tslib_1.__awaiter(this, void 0, void 0, function* () {
        ipc.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    }));
}
exports.makeRendererTransport = makeRendererTransport;
//# sourceMappingURL=transport.js.map