Object.defineProperty(exports, "__esModule", { value: true });
exports.electronRendererStackParser = void 0;
const browser_1 = require("@sentry/browser");
const utils_1 = require("@sentry/utils");
const [, chrome] = browser_1.chromeStackLineParser;
const [, node] = (0, utils_1.nodeStackLineParser)();
/**
 * A stack parser than combines Chrome and node.js parsers to give the best results even when nodeIntegration = true
 */
const electronRendererStackParser = (stack, skipFirst = 0) => {
    const frames = [];
    for (const line of stack.split('\n').slice(skipFirst)) {
        const chromeFrame = chrome(line);
        const nodeFrame = node(line);
        // We favour the chrome parser unless in_app == false
        if (chromeFrame && (nodeFrame === null || nodeFrame === void 0 ? void 0 : nodeFrame.in_app) !== false) {
            frames.push(chromeFrame);
        }
        else if (nodeFrame) {
            frames.push((0, utils_1.dropUndefinedKeys)(nodeFrame));
        }
    }
    return (0, utils_1.stripSentryFramesAndReverse)(frames);
};
exports.electronRendererStackParser = electronRendererStackParser;
//# sourceMappingURL=stack-parse.js.map