Object.defineProperty(exports, "__esModule", { value: true });
exports.init = exports.defaultIntegrations = void 0;
/* eslint-disable no-restricted-globals */
const browser_1 = require("@sentry/browser");
const utils_1 = require("@sentry/utils");
const common_1 = require("../common");
const integrations_1 = require("./integrations");
const stack_parse_1 = require("./stack-parse");
const transport_1 = require("./transport");
exports.defaultIntegrations = [...browser_1.defaultIntegrations, new integrations_1.ScopeToMain()];
/**
 * Initialize Sentry in the Electron renderer process
 * @param options SDK options
 * @param originalInit Optional init function for a specific framework SDK
 * @returns
 */
function init(options = {}, 
// This parameter name ensures that TypeScript error messages contain a hint for fixing SDK version mismatches
originalInit = browser_1.init) {
    (0, common_1.ensureProcess)('renderer');
    // Ensure the browser SDK is only init'ed once.
    if (window === null || window === void 0 ? void 0 : window.__SENTRY__RENDERER_INIT__) {
        utils_1.logger.warn(`The browser SDK has already been initialized.
If init has been called in the preload and contextIsolation is disabled, is not required to call init in the renderer`);
        return;
    }
    window.__SENTRY__RENDERER_INIT__ = true;
    // We don't want browser session tracking enabled by default because we already have Electron
    // specific session tracking
    if (options.autoSessionTracking === undefined) {
        options.autoSessionTracking = false;
    }
    // Disable client reports for renderer as the sdk should only send
    // events using the main process.
    options.sendClientReports = false;
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = exports.defaultIntegrations;
    }
    if (options.stackParser === undefined) {
        options.stackParser = stack_parse_1.electronRendererStackParser;
    }
    if (options.dsn === undefined) {
        // Events are sent via the main process but browser SDK wont start without dsn
        options.dsn = 'https://12345@dummy.dsn/12345';
    }
    if (options.transport === undefined) {
        options.transport = transport_1.makeRendererTransport;
    }
    // We only handle initialScope in the main process otherwise it can cause race conditions over IPC
    delete options.initialScope;
    originalInit(options);
}
exports.init = init;
//# sourceMappingURL=sdk.js.map