Object.defineProperty(exports, "__esModule", { value: true });
exports.getIPC = void 0;
/* eslint-disable no-restricted-globals */
/* eslint-disable no-console */
const utils_1 = require("@sentry/utils");
const common_1 = require("../common");
/** Gets the available IPC implementation */
function getImplementation() {
    // Favour IPC if it's been exposed by a preload script
    if (window.__SENTRY_IPC__) {
        return window.__SENTRY_IPC__;
    }
    utils_1.logger.log('IPC was not configured in preload script, falling back to custom protocol and fetch');
    fetch(`${common_1.PROTOCOL_SCHEME}://${common_1.IPCChannel.PING}/sentry_key`, { method: 'POST', body: '' }).catch(() => console.error(`Sentry SDK failed to establish connection with the Electron main process.
 - Ensure you have initialized the SDK in the main process
 - If your renderers use custom sessions, be sure to set 'getSessions' in the main process options
 - If you are bundling your main process code and using Electron < v5, you'll need to manually configure a preload script`));
    // We include sentry_key in the URL so these dont end up in fetch breadcrumbs
    // https://github.com/getsentry/sentry-javascript/blob/a3f70d8869121183bec037571a3ee78efaf26b0b/packages/browser/src/integrations/breadcrumbs.ts#L240
    return {
        sendScope: (body) => {
            fetch(`${common_1.PROTOCOL_SCHEME}://${common_1.IPCChannel.SCOPE}/sentry_key`, { method: 'POST', body }).catch(() => {
                // ignore
            });
        },
        sendEvent: (body) => {
            fetch(`${common_1.PROTOCOL_SCHEME}://${common_1.IPCChannel.EVENT}/sentry_key`, { method: 'POST', body }).catch(() => {
                // ignore
            });
        },
        sendEnvelope: (body) => {
            fetch(`${common_1.PROTOCOL_SCHEME}://${common_1.IPCChannel.ENVELOPE}/sentry_key`, { method: 'POST', body }).catch(() => {
                // ignore
            });
        },
    };
}
let cachedInterface;
/**
 * Renderer IPC interface
 *
 * Favours IPC if its been exposed via a preload script but will
 * fallback to custom protocol and fetch if IPC is not available
 */
function getIPC() {
    if (!cachedInterface) {
        cachedInterface = getImplementation();
    }
    return cachedInterface;
}
exports.getIPC = getIPC;
//# sourceMappingURL=ipc.js.map