Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopeToMain = void 0;
const core_1 = require("@sentry/core");
const utils_1 = require("@sentry/utils");
const ipc_1 = require("../ipc");
/**
 * Passes scope changes to the main process.
 */
class ScopeToMain {
    constructor() {
        /** @inheritDoc */
        this.name = ScopeToMain.id;
    }
    /** @inheritDoc */
    setupOnce() {
        this._setupScopeListener();
    }
    /**
     * Sends the scope to the main process when it updates.
     */
    _setupScopeListener() {
        const scope = (0, core_1.getCurrentHub)().getScope();
        if (scope) {
            const ipc = (0, ipc_1.getIPC)();
            scope.addScopeListener((updatedScope) => {
                ipc.sendScope(JSON.stringify((0, utils_1.normalize)(updatedScope, 20, 2000)));
                scope.clearBreadcrumbs();
                scope.clearAttachments();
            });
        }
    }
}
exports.ScopeToMain = ScopeToMain;
/** @inheritDoc */
ScopeToMain.id = 'ScopeToMain';
//# sourceMappingURL=scope-to-main.js.map