Object.defineProperty(exports, "__esModule", { value: true });
exports.EventToMain = void 0;
const utils_1 = require("@sentry/utils");
const ipc_1 = require("../ipc");
/**
 * Passes events to the main process.
 */
class EventToMain {
    constructor() {
        /** @inheritDoc */
        this.name = EventToMain.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        const ipc = (0, ipc_1.getIPC)();
        addGlobalEventProcessor((event) => {
            // Ensure breadcrumbs is not `undefined` as `walk` translates it into a string
            event.breadcrumbs = event.breadcrumbs || [];
            // Remove the environment as it defaults to 'production' and overwrites the main process environment
            delete event.environment;
            ipc.sendEvent(JSON.stringify((0, utils_1.normalize)(event, 20, 2000)));
            // Events are handled and sent from the main process so we return null here so nothing is sent from the renderer
            return null;
        });
    }
}
exports.EventToMain = EventToMain;
/** @inheritDoc */
EventToMain.id = 'EventToMain';
//# sourceMappingURL=event-to-main.js.map