"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var PROTOCOL_SCHEME = 'sentry-ipc';
var IPCChannel;
(function (IPCChannel) {
    IPCChannel["PING"] = "sentry-electron.ping";
    IPCChannel["EVENT"] = "sentry-electron.event";
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
})(IPCChannel || (IPCChannel = {}));
;
if (window.__SENTRY_IPC__) {
    console.log('Sentry Electron preload has already been run');
}
else {
    var ipcObject = {
        sendScope: function (scopeJson) { return electron_1.ipcRenderer.send(IPCChannel.SCOPE, scopeJson); },
        sendEvent: function (eventJson) { return electron_1.ipcRenderer.send(IPCChannel.EVENT, eventJson); },
        sendEnvelope: function (envelope) { return electron_1.ipcRenderer.send(IPCChannel.ENVELOPE, envelope); },
    };
    window.__SENTRY_IPC__ = ipcObject;
    if (electron_1.contextBridge) {
        try {
            electron_1.contextBridge.exposeInMainWorld('__SENTRY_IPC__', ipcObject);
        }
        catch (e) {
        }
    }
}
