import { Integration } from '@sentry/types';
import type { RecordingOptions, ReplayConfiguration, ReplayPluginOptions } from './types';
/**
 * The main replay integration class, to be passed to `init({  integrations: [] })`.
 */
export declare class Replay implements Integration {
    /**
     * @inheritDoc
     */
    static id: string;
    /**
     * @inheritDoc
     */
    name: string;
    /**
     * Options to pass to `rrweb.record()`
     */
    readonly recordingOptions: RecordingOptions;
    readonly options: ReplayPluginOptions;
    private _replay?;
    constructor({ flushMinDelay, flushMaxDelay, initialFlushDelay, stickySession, useCompression, sessionSampleRate, errorSampleRate, maskAllText, maskTextSelector, maskAllInputs, blockAllMedia, _experiments, blockClass, ignoreClass, maskTextClass, blockSelector, ...recordingOptions }?: ReplayConfiguration);
    /** If replay has already been initialized */
    protected get _isInitialized(): boolean;
    /** Update _isInitialized */
    protected set _isInitialized(value: boolean);
    /**
     * We previously used to create a transaction in `setupOnce` and it would
     * potentially create a transaction before some native SDK integrations have run
     * and applied their own global event processor. An example is:
     * https://github.com/getsentry/sentry-javascript/blob/b47ceafbdac7f8b99093ce6023726ad4687edc48/packages/browser/src/integrations/useragent.ts
     *
     * So we call `replay.setup` in next event loop as a workaround to wait for other
     * global event processors to finish. This is no longer needed, but keeping it
     * here to avoid any future issues.
     */
    setupOnce(): void;
    /**
     * Initializes the plugin.
     *
     * Creates or loads a session, attaches listeners to varying events (DOM,
     * PerformanceObserver, Recording, Sentry SDK, etc)
     */
    start(): void;
    /**
     * Currently, this needs to be manually called (e.g. for tests). Sentry SDK
     * does not support a teardown
     */
    stop(): void;
    /** Setup the integration. */
    private _setup;
    /** Parse Replay-related options from SDK options */
    private _loadReplayOptionsFromClient;
}
//# sourceMappingURL=integration.d.ts.map