import { ReplayRecordingData } from '@sentry/types';
import type { EventBuffer, RecordingEvent } from './types';
interface CreateEventBufferParams {
    useCompression: boolean;
}
/**
 * Create an event buffer for replays.
 */
export declare function createEventBuffer({ useCompression }: CreateEventBufferParams): EventBuffer;
/**
 * Event buffer that uses a web worker to compress events.
 * Exported only for testing.
 */
export declare class EventBufferCompressionWorker implements EventBuffer {
    private _worker;
    private _eventBufferItemLength;
    private _id;
    constructor(worker: Worker);
    /**
     * Note that this may not reflect what is actually in the event buffer. This
     * is only a local count of the buffer size since `addEvent` is async.
     */
    get length(): number;
    /**
     * Destroy the event buffer.
     */
    destroy(): void;
    /**
     * Add an event to the event buffer.
     */
    addEvent(event: RecordingEvent, isCheckout?: boolean): Promise<ReplayRecordingData>;
    /**
     * Finish the event buffer and return the compressed data.
     */
    finish(): Promise<Uint8Array>;
    /**
     * Post message to worker and wait for response before resolving promise.
     */
    private _postMessage;
    /**
     * Send the event to the worker.
     */
    private _sendEventToWorker;
    /**
     * Finish the request and return the compressed data from the worker.
     */
    private _finishRequest;
    /** Get the current ID and increment it for the next call. */
    private _getAndIncrementId;
}
export {};
//# sourceMappingURL=eventBuffer.d.ts.map