import { prepareEvent } from '@sentry/core';

/**
 * Prepare a replay event & enrich it with the SDK metadata.
 */
async function prepareReplayEvent({
  client,
  scope,
  replayId: event_id,
  event,
}

) {
  const preparedEvent = (await prepareEvent(client.getOptions(), event, { event_id }, scope)) ;

  // If e.g. a global event processor returned null
  if (!preparedEvent) {
    return null;
  }

  // This normally happens in browser client "_prepareEvent"
  // but since we do not use this private method from the client, but rather the plain import
  // we need to do this manually.
  preparedEvent.platform = preparedEvent.platform || 'javascript';

  // extract the SDK name because `client._prepareEvent` doesn't add it to the event
  const metadata = client.getSdkMetadata && client.getSdkMetadata();
  const name = (metadata && metadata.sdk && metadata.sdk.name) || 'sentry.javascript.unknown';

  preparedEvent.sdk = {
    ...preparedEvent.sdk,
    version: "7.30.0",
    name,
  };

  return preparedEvent;
}

export { prepareReplayEvent };
//# sourceMappingURL=prepareReplayEvent.js.map
