import '../node_modules/rrweb/es/rrweb/packages/rrweb/src/entries/all.js';
import { addEvent } from './addEvent.js';
import { EventType } from '../node_modules/rrweb/es/rrweb/packages/rrweb/src/types.js';

/**
 * Create a "span" for each performance entry. The parent transaction is `this.replayEvent`.
 */
function createPerformanceSpans(replay, entries) {
  entries.map(({ type, start, end, name, data }) =>
    addEvent(replay, {
      type: EventType.Custom,
      timestamp: start,
      data: {
        tag: 'performanceSpan',
        payload: {
          op: type,
          description: name,
          startTimestamp: start,
          endTimestamp: end,
          data,
        },
      },
    }),
  );
}

export { createPerformanceSpans };
//# sourceMappingURL=createPerformanceSpans.js.map
