import { WINDOW, REPLAY_SESSION_KEY } from '../constants.js';
import { makeSession } from './Session.js';

/**
 * Fetches a session from storage
 */
function fetchSession() {
  const hasSessionStorage = 'sessionStorage' in WINDOW;

  if (!hasSessionStorage) {
    return null;
  }

  try {
    // This can throw if cookies are disabled
    const sessionStringFromStorage = WINDOW.sessionStorage.getItem(REPLAY_SESSION_KEY);

    if (!sessionStringFromStorage) {
      return null;
    }

    const sessionObj = JSON.parse(sessionStringFromStorage) ;

    return makeSession(sessionObj);
  } catch (e) {
    return null;
  }
}

export { fetchSession };
//# sourceMappingURL=fetchSession.js.map
