import { WINDOW, REPLAY_SESSION_KEY } from '../constants.js';

/**
 * Deletes a session from storage
 */
function deleteSession() {
  const hasSessionStorage = 'sessionStorage' in WINDOW;

  if (!hasSessionStorage) {
    return;
  }

  try {
    WINDOW.sessionStorage.removeItem(REPLAY_SESSION_KEY);
  } catch (e) {
    // Ignore potential SecurityError exceptions
  }
}

export { deleteSession };
//# sourceMappingURL=deleteSession.js.map
