import { logger } from '@sentry/utils';
import { saveSession } from './saveSession.js';
import { getSessionSampleType, makeSession } from './Session.js';

/**
 * Create a new session, which in its current implementation is a Sentry event
 * that all replays will be saved to as attachments. Currently, we only expect
 * one of these Sentry events per "replay session".
 */
function createSession({ sessionSampleRate, errorSampleRate, stickySession = false }) {
  const sampled = getSessionSampleType(sessionSampleRate, errorSampleRate);
  const session = makeSession({
    sampled,
  });

  (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && logger.log(`[Replay] Creating new session: ${session.id}`);

  if (stickySession) {
    saveSession(session);
  }

  return session;
}

export { createSession };
//# sourceMappingURL=createSession.js.map
