import { uuid4 } from '@sentry/utils';
import { isSampled } from '../util/isSampled.js';

/**
 * Get a session with defaults & applied sampling.
 */
function makeSession(session) {
  const now = new Date().getTime();
  const id = session.id || uuid4();
  // Note that this means we cannot set a started/lastActivity of `0`, but this should not be relevant outside of tests.
  const started = session.started || now;
  const lastActivity = session.lastActivity || now;
  const segmentId = session.segmentId || 0;
  const sampled = session.sampled;

  return {
    id,
    started,
    lastActivity,
    segmentId,
    sampled,
  };
}

/**
 * Get the sampled status for a session based on sample rates & current sampled status.
 */
function getSessionSampleType(sessionSampleRate, errorSampleRate) {
  return isSampled(sessionSampleRate) ? 'session' : isSampled(errorSampleRate) ? 'error' : false;
}

export { getSessionSampleType, makeSession };
//# sourceMappingURL=Session.js.map
