import { htmlTreeAsString } from '@sentry/utils';
import '../node_modules/rrweb/es/rrweb/packages/rrweb/src/entries/all.js';
import { createBreadcrumb } from '../util/createBreadcrumb.js';
import record from '../node_modules/rrweb/es/rrweb/packages/rrweb/src/record/index.js';

/**
 * An event handler to react to DOM events.
 */
function handleDom(handlerData) {
  // Taken from https://github.com/getsentry/sentry-javascript/blob/master/packages/browser/src/integrations/breadcrumbs.ts#L112
  let target;
  let targetNode;

  // Accessing event.target can throw (see getsentry/raven-js#838, #768)
  try {
    targetNode = getTargetNode(handlerData);
    target = htmlTreeAsString(targetNode);
  } catch (e) {
    target = '<unknown>';
  }

  if (target.length === 0) {
    return null;
  }

  return createBreadcrumb({
    category: `ui.${handlerData.name}`,
    message: target,
    data: {
      // Not sure why this errors, Node should be correct (Argument of type 'Node' is not assignable to parameter of type 'INode')
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      ...(targetNode ? { nodeId: record.mirror.getId(targetNode ) } : {}),
    },
  });
}

function getTargetNode(handlerData) {
  if (isEventWithTarget(handlerData.event)) {
    return handlerData.event.target;
  }

  return handlerData.event;
}

function isEventWithTarget(event) {
  return !!(event ).target;
}

export { handleDom };
//# sourceMappingURL=handleDom.js.map
