var {
  _optionalChain
} = require('@sentry/utils/cjs/buildPolyfills');

Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');

/**
 * Check whether a given request URL should be filtered out.
 */
function shouldFilterRequest(replay, url) {
  // If we enabled the `traceInternals` experiment, we want to trace everything
  if ((typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && _optionalChain([replay, 'access', _ => _.getOptions, 'call', _2 => _2(), 'access', _3 => _3._experiments, 'optionalAccess', _4 => _4.traceInternals])) {
    return false;
  }

  return !_isSentryRequest(url);
}

/**
 * Checks wether a given URL belongs to the configured Sentry DSN.
 */
function _isSentryRequest(url) {
  const dsn = _optionalChain([core.getCurrentHub, 'call', _5 => _5(), 'access', _6 => _6.getClient, 'call', _7 => _7(), 'optionalAccess', _8 => _8.getDsn, 'call', _9 => _9()]);
  return dsn ? url.includes(dsn.host) : false;
}

exports.shouldFilterRequest = shouldFilterRequest;
//# sourceMappingURL=shouldFilterRequest.js.map
