Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');

let _originalRecordDroppedEvent;

/**
 * Overwrite the `recordDroppedEvent` method on the client, so we can find out which events were dropped.
 * */
function overwriteRecordDroppedEvent(errorIds) {
  const client = core.getCurrentHub().getClient();

  if (!client) {
    return;
  }

  const _originalCallback = client.recordDroppedEvent.bind(client);

  const recordDroppedEvent = (
    reason,
    category,
    event,
  ) => {
    if (event && !event.type && event.event_id) {
      errorIds.delete(event.event_id);
    }

    return _originalCallback(reason, category, event);
  };

  client.recordDroppedEvent = recordDroppedEvent;
  _originalRecordDroppedEvent = _originalCallback;
}

/**
 * Restore the original method.
 * */
function restoreRecordDroppedEvent() {
  const client = core.getCurrentHub().getClient();

  if (!client || !_originalRecordDroppedEvent) {
    return;
  }

  client.recordDroppedEvent = _originalRecordDroppedEvent;
}

exports.overwriteRecordDroppedEvent = overwriteRecordDroppedEvent;
exports.restoreRecordDroppedEvent = restoreRecordDroppedEvent;
//# sourceMappingURL=monkeyPatchRecordDroppedEvent.js.map
