var {
  _optionalChain
} = require('@sentry/utils/cjs/buildPolyfills');

Object.defineProperty(exports, '__esModule', { value: true });

const constants = require('../constants.js');
const isExpired = require('./isExpired.js');

/**
 * Checks to see if session is expired
 */
function isSessionExpired(session, idleTimeout, targetTime = +new Date()) {
  return (
    // First, check that maximum session length has not been exceeded
    isExpired.isExpired(session.started, constants.MAX_SESSION_LIFE, targetTime) ||
    // check that the idle timeout has not been exceeded (i.e. user has
    // performed an action within the last `idleTimeout` ms)
    isExpired.isExpired(_optionalChain([session, 'optionalAccess', _ => _.lastActivity]), idleTimeout, targetTime)
  );
}

exports.isSessionExpired = isSessionExpired;
//# sourceMappingURL=isSessionExpired.js.map
