var {
  _optionalChain
} = require('@sentry/utils/cjs/buildPolyfills');

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Returns true if we think the given event is an error originating inside of rrweb.
 */
function isRrwebError(event) {
  if (event.type || !_optionalChain([event, 'access', _ => _.exception, 'optionalAccess', _2 => _2.values, 'optionalAccess', _3 => _3.length])) {
    return false;
  }

  // Check if any exception originates from rrweb
  return event.exception.values.some(exception => {
    if (!_optionalChain([exception, 'access', _4 => _4.stacktrace, 'optionalAccess', _5 => _5.frames, 'optionalAccess', _6 => _6.length])) {
      return false;
    }

    return exception.stacktrace.frames.some(frame => _optionalChain([frame, 'access', _7 => _7.filename, 'optionalAccess', _8 => _8.includes, 'call', _9 => _9('/rrweb/src/')]));
  });
}

exports.isRrwebError = isRrwebError;
//# sourceMappingURL=isRrwebError.js.map
