Object.defineProperty(exports, '__esModule', { value: true });

const constants = require('../constants.js');
const createPerformanceSpans = require('./createPerformanceSpans.js');

/**
 * Create a "span" for the total amount of memory being used by JS objects
 * (including v8 internal objects).
 */
function addMemoryEntry(replay) {
  // window.performance.memory is a non-standard API and doesn't work on all browsers, so we try-catch this
  try {
    createPerformanceSpans.createPerformanceSpans(replay, [
      // @ts-ignore memory doesn't exist on type Performance as the API is non-standard (we check that it exists above)
      createMemoryEntry(constants.WINDOW.performance.memory),
    ]);
  } catch (error) {
    // Do nothing
  }
}

function createMemoryEntry(memoryEntry) {
  const { jsHeapSizeLimit, totalJSHeapSize, usedJSHeapSize } = memoryEntry;
  // we don't want to use `getAbsoluteTime` because it adds the event time to the
  // time origin, so we get the current timestamp instead
  const time = new Date().getTime() / 1000;
  return {
    type: 'memory',
    name: 'memory',
    start: time,
    end: time,
    data: {
      memory: {
        jsHeapSizeLimit,
        totalJSHeapSize,
        usedJSHeapSize,
      },
    },
  };
}

exports.addMemoryEntry = addMemoryEntry;
//# sourceMappingURL=addMemoryEntry.js.map
