Object.defineProperty(exports, '__esModule', { value: true });

const constants = require('../constants.js');
const Session = require('./Session.js');

/**
 * Fetches a session from storage
 */
function fetchSession() {
  const hasSessionStorage = 'sessionStorage' in constants.WINDOW;

  if (!hasSessionStorage) {
    return null;
  }

  try {
    // This can throw if cookies are disabled
    const sessionStringFromStorage = constants.WINDOW.sessionStorage.getItem(constants.REPLAY_SESSION_KEY);

    if (!sessionStringFromStorage) {
      return null;
    }

    const sessionObj = JSON.parse(sessionStringFromStorage) ;

    return Session.makeSession(sessionObj);
  } catch (e) {
    return null;
  }
}

exports.fetchSession = fetchSession;
//# sourceMappingURL=fetchSession.js.map
