Object.defineProperty(exports, '__esModule', { value: true });

const constants = require('../constants.js');

/**
 * Deletes a session from storage
 */
function deleteSession() {
  const hasSessionStorage = 'sessionStorage' in constants.WINDOW;

  if (!hasSessionStorage) {
    return;
  }

  try {
    constants.WINDOW.sessionStorage.removeItem(constants.REPLAY_SESSION_KEY);
  } catch (e) {
    // Ignore potential SecurityError exceptions
  }
}

exports.deleteSession = deleteSession;
//# sourceMappingURL=deleteSession.js.map
