Object.defineProperty(exports, '__esModule', { value: true });

const utils = require('@sentry/utils');
const saveSession = require('./saveSession.js');
const Session = require('./Session.js');

/**
 * Create a new session, which in its current implementation is a Sentry event
 * that all replays will be saved to as attachments. Currently, we only expect
 * one of these Sentry events per "replay session".
 */
function createSession({ sessionSampleRate, errorSampleRate, stickySession = false }) {
  const sampled = Session.getSessionSampleType(sessionSampleRate, errorSampleRate);
  const session = Session.makeSession({
    sampled,
  });

  (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) && utils.logger.log(`[Replay] Creating new session: ${session.id}`);

  if (stickySession) {
    saveSession.saveSession(session);
  }

  return session;
}

exports.createSession = createSession;
//# sourceMappingURL=createSession.js.map
