Object.defineProperty(exports, '__esModule', { value: true });

const utils = require('@sentry/utils');
const isSampled = require('../util/isSampled.js');

/**
 * Get a session with defaults & applied sampling.
 */
function makeSession(session) {
  const now = new Date().getTime();
  const id = session.id || utils.uuid4();
  // Note that this means we cannot set a started/lastActivity of `0`, but this should not be relevant outside of tests.
  const started = session.started || now;
  const lastActivity = session.lastActivity || now;
  const segmentId = session.segmentId || 0;
  const sampled = session.sampled;

  return {
    id,
    started,
    lastActivity,
    segmentId,
    sampled,
  };
}

/**
 * Get the sampled status for a session based on sample rates & current sampled status.
 */
function getSessionSampleType(sessionSampleRate, errorSampleRate) {
  return isSampled.isSampled(sessionSampleRate) ? 'session' : isSampled.isSampled(errorSampleRate) ? 'error' : false;
}

exports.getSessionSampleType = getSessionSampleType;
exports.makeSession = makeSession;
//# sourceMappingURL=Session.js.map
