Object.defineProperty(exports, '__esModule', { value: true });

const types = require('../../types.js');
const webgl = require('./webgl.js');
const _2d = require('./2d.js');

function canvasMutation(_a) {
    var event = _a.event, mutation = _a.mutation, target = _a.target, imageMap = _a.imageMap, errorHandler = _a.errorHandler;
    try {
        var mutations = 'commands' in mutation ? mutation.commands : [mutation];
        if ([types.CanvasContext.WebGL, types.CanvasContext.WebGL2].includes(mutation.type)) {
            return mutations.forEach(function (command) {
                webgl.default({
                    mutation: command,
                    type: mutation.type,
                    target: target,
                    imageMap: imageMap,
                    errorHandler: errorHandler,
                });
            });
        }
        return mutations.forEach(function (command) {
            _2d.default({
                event: event,
                mutation: command,
                target: target,
                imageMap: imageMap,
                errorHandler: errorHandler,
            });
        });
    }
    catch (error) {
        errorHandler(mutation, error);
    }
}

exports.default = canvasMutation;
//# sourceMappingURL=index.js.map
