Object.defineProperty(exports, '__esModule', { value: true });

const tslib_es6 = require('../../../../ext/tslib/tslib.es6.js');
const utils = require('../../../utils.js');

function initCanvasContextObserver(win, blockClass) {
    var handlers = [];
    try {
        var restoreHandler = utils.patch(win.HTMLCanvasElement.prototype, 'getContext', function (original) {
            return function (contextType) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (!utils.isBlocked(this, blockClass)) {
                    if (!('__context' in this))
                        this.__context = contextType;
                }
                return original.apply(this, tslib_es6.__spreadArray([contextType], tslib_es6.__read(args), false));
            };
        });
        handlers.push(restoreHandler);
    }
    catch (_a) {
        console.error('failed to patch HTMLCanvasElement.prototype.getContext');
    }
    return function () {
        handlers.forEach(function (h) { return h(); });
    };
}

exports.default = initCanvasContextObserver;
//# sourceMappingURL=canvas.js.map
