Object.defineProperty(exports, '__esModule', { value: true });

const browser = require('../../../../ext/fflate/esm/browser.js');
const base = require('./base.js');

var unpack = function (raw) {
    if (typeof raw !== 'string') {
        return raw;
    }
    try {
        var e = JSON.parse(raw);
        if (e.timestamp) {
            return e;
        }
    }
    catch (error) {
    }
    try {
        var e = JSON.parse(browser.strFromU8(browser.unzlibSync(browser.strToU8(raw, true))));
        if (e.v === base.MARK) {
            return e;
        }
        throw new Error("These events were packed with packer ".concat(e.v, " which is incompatible with current packer ").concat(base.MARK, "."));
    }
    catch (error) {
        console.error(error);
        throw new Error('Unknown data format.');
    }
};

exports.unpack = unpack;
//# sourceMappingURL=unpack.js.map
