Object.defineProperty(exports, '__esModule', { value: true });

const dedupePerformanceEntries = require('../util/dedupePerformanceEntries.js');

/**
 * Sets up a PerformanceObserver to listen to all performance entry types.
 */
function setupPerformanceObserver(replay) {
  const performanceObserverHandler = (list) => {
    // For whatever reason the observer was returning duplicate navigation
    // entries (the other entry types were not duplicated).
    const newPerformanceEntries = dedupePerformanceEntries.dedupePerformanceEntries(
      replay.performanceEvents,
      list.getEntries() ,
    );
    replay.performanceEvents = newPerformanceEntries;
  };

  const performanceObserver = new PerformanceObserver(performanceObserverHandler);

  [
    'element',
    'event',
    'first-input',
    'largest-contentful-paint',
    'layout-shift',
    'longtask',
    'navigation',
    'paint',
    'resource',
  ].forEach(type => {
    try {
      performanceObserver.observe({
        type,
        buffered: true,
      });
    } catch (e) {
      // This can throw if an entry type is not supported in the browser.
      // Ignore these errors.
    }
  });

  return performanceObserver;
}

exports.setupPerformanceObserver = setupPerformanceObserver;
//# sourceMappingURL=performanceObserver.js.map
