Object.defineProperty(exports, '__esModule', { value: true });

const utils = require('@sentry/utils');

// exporting a separate copy of `WINDOW` rather than exporting the one from `@sentry/browser`
// prevents the browser package from being bundled in the CDN bundle, and avoids a
// circular dependency between the browser and replay packages should `@sentry/browser` import
// from `@sentry/replay` in the future
const WINDOW = utils.GLOBAL_OBJ ;

const REPLAY_SESSION_KEY = 'sentryReplaySession';
const REPLAY_EVENT_NAME = 'replay_event';
const RECORDING_EVENT_NAME = 'replay_recording';
const UNABLE_TO_SEND_REPLAY = 'Unable to send Replay';

// The idle limit for a session
const SESSION_IDLE_DURATION = 300000; // 5 minutes in ms

// Grace period to keep a session when a user changes tabs or hides window
const VISIBILITY_CHANGE_TIMEOUT = SESSION_IDLE_DURATION;

// The maximum length of a session
const MAX_SESSION_LIFE = 3600000; // 60 minutes

/**
 * Defaults for sampling rates
 */
const DEFAULT_SESSION_SAMPLE_RATE = 0.1;
const DEFAULT_ERROR_SAMPLE_RATE = 1.0;

/** The select to use for the `maskAllText` option  */
const MASK_ALL_TEXT_SELECTOR = 'body *:not(style), body *:not(script)';

/** Default flush delays */
const DEFAULT_FLUSH_MIN_DELAY = 5000;
const DEFAULT_FLUSH_MAX_DELAY = 15000;
const INITIAL_FLUSH_DELAY = 5000;

exports.DEFAULT_ERROR_SAMPLE_RATE = DEFAULT_ERROR_SAMPLE_RATE;
exports.DEFAULT_FLUSH_MAX_DELAY = DEFAULT_FLUSH_MAX_DELAY;
exports.DEFAULT_FLUSH_MIN_DELAY = DEFAULT_FLUSH_MIN_DELAY;
exports.DEFAULT_SESSION_SAMPLE_RATE = DEFAULT_SESSION_SAMPLE_RATE;
exports.INITIAL_FLUSH_DELAY = INITIAL_FLUSH_DELAY;
exports.MASK_ALL_TEXT_SELECTOR = MASK_ALL_TEXT_SELECTOR;
exports.MAX_SESSION_LIFE = MAX_SESSION_LIFE;
exports.RECORDING_EVENT_NAME = RECORDING_EVENT_NAME;
exports.REPLAY_EVENT_NAME = REPLAY_EVENT_NAME;
exports.REPLAY_SESSION_KEY = REPLAY_SESSION_KEY;
exports.SESSION_IDLE_DURATION = SESSION_IDLE_DURATION;
exports.UNABLE_TO_SEND_REPLAY = UNABLE_TO_SEND_REPLAY;
exports.VISIBILITY_CHANGE_TIMEOUT = VISIBILITY_CHANGE_TIMEOUT;
exports.WINDOW = WINDOW;
//# sourceMappingURL=constants.js.map
